	list p=18f4580
	#include <p18f4580.inc>
	ERRORLEVEL-207												;<------------------------------------------
	radix dec
; Begin
	R0L EQU 0x000
	R0H EQU 0x001
	R1L EQU 0x002
	R1H EQU 0x003
	R2L EQU 0x004
	R2H EQU 0x005
	R3L EQU 0x006
	R3H EQU 0x007
	R4L EQU 0x008
	R4H EQU 0x009
	R5L EQU 0x00A
	R5H EQU 0x00B
	R6L EQU 0x00C
	R6H EQU 0x00D
	R7L EQU 0x00E
	R7H EQU 0x00F
	R8L EQU 0x010
	R8H EQU 0x011
	R9L EQU 0x012
	R9H EQU 0x013
	ORG 0x000000
	BSF RCON,IPEN
	GOTO L0048
	ORG 0x000008
	CALL L0049
	RETFIE FAST
	ORG 0x000018
	RETFIE FAST
; Begin of program
L0048:
; 1:  'Digitale logische analyser with 128x64 Graphical LCD
; 2: 
; 3:  '***************** April. 10th. 2007 **************************
; 4:  'Written by Ronald de Bruijn
; 5: 
; 6:  'Vier kanalen
; 7:  '- De specificaties zijn.
; 8:  '- Sampling rate: 200 Hz min., 2MHz max.
; 9:  '- Aantal kanalen: vier
; 10:  '- Geheugendiepte: 1024 samples
; 11:  '- Triggercondities: "-","+"
; 12:  '- Trigger-patronen: in te stellen voor alle vier de ingangen
; 13:  '- Grafisch LCD: 64 x 128 pixels
; 14: 
; 15: 
; 16: Define CLOCK_FREQUENCY = 40
; 17: Define CONFIG1L = 0x00
; 18: Define CONFIG1H = 0x06
; 19: Define CONFIG2L = 0x0e
; 20: Define CONFIG2H = 0x00
; 21: Define CONFIG3L = 0x00
; 22: Define CONFIG3H = 0x00
; 23: Define CONFIG4L = 0x80
; 24: Define CONFIG4H = 0x00
; 25: Define CONFIG5L = 0x0f
; 26: Define CONFIG5H = 0xc0
; 27: Define CONFIG6L = 0x0f
; 28: Define CONFIG6H = 0xe0
; 29: Define CONFIG7L = 0x0f
; 30: Define CONFIG7H = 0x40
; 31: 
; 32: 
; 33: Define GLCD_DREG = PORTD
; 34: Define GLCD_RSREG = PORTC
; 35: Define GLCD_RSBIT = 0
; 36: Define GLCD_EREG = PORTE
; 37: Define GLCD_EBIT = 0
; 38: Define GLCD_RWREG = PORTC
; 39: Define GLCD_RWBIT = 1
; 40: Define GLCD_CS1REG = PORTE
; 41: Define GLCD_CS1BIT = 1
; 42: Define GLCD_CS2REG = PORTE
; 43: Define GLCD_CS2BIT = 2
; 44: 
; 45: 
; 46: Const c_key1 = 1
;       The value of 'c_key1' is 1
	c_key1 EQU 0x000001
; 47: Const c_key2 = 2
;       The value of 'c_key2' is 2
	c_key2 EQU 0x000002
; 48: Const c_key3 = 3
;       The value of 'c_key3' is 3
	c_key3 EQU 0x000003
; 49: Const c_key4 = 4
;       The value of 'c_key4' is 4
	c_key4 EQU 0x000004
; 50: Const c_key5 = 5
;       The value of 'c_key5' is 5
	c_key5 EQU 0x000005
; 51: 
; 52: Dim an0 As Word
;       The address of 'an0' is 0x015
	ano EQU 0x015														;<------------------------------------------
; 53: Dim aa As Byte 'used in sound subroutine
;       The address of 'aa' is 0x017
	aa EQU 0x017
; 54: Dim y As Byte
;       The address of 'y' is 0x018
	y EQU 0x018
; 55: Dim yy As Byte
;       The address of 'yy' is 0x019
	yy EQU 0x019
; 56: Dim x As Byte
;       The address of 'x' is 0x01A
	x EQU 0x01A
; 57: Dim xx As Byte
;       The address of 'xx' is 0x01B
	xx EQU 0x01B
; 58: Dim st As Byte 'Sample tijd
;       The address of 'st' is 0x01C
	st EQU 0x01C
; 59: Dim st1 As Byte
;       The address of 'st1' is 0x01D
	st1 EQU 0x01D
; 60: Dim trig_int As Byte 'tijd per div.
;       The address of 'trig_int' is 0x01E
	trig_int EQU 0x01E
; 61: Dim sample(256) As Byte
;       The address of 'sample' is 0x100
	sample EQU 0x100
; 62: Dim sample_1 As Byte
;       The address of 'sample_1' is 0x01F
	sample_1 EQU 0x01F
; 63: Dim sample_2 As Byte
;       The address of 'sample_2' is 0x020
	sample_2 EQU 0x020
; 64: Dim max As Byte
;       The address of 'max' is 0x021
	max EQU 0x021
; 65: Dim beginw As Word
;       The address of 'beginw' is 0x022
	beginw EQU 0x022
; 66: Dim cursor_pos As Byte
;       The address of 'cursor_pos' is 0x024
	cursor_pos EQU 0x024
; 67: Dim temp As Byte
;       The address of 'temp' is 0x025
	temp EQU 0x025
; 68: Dim us_register As Byte
;       The address of 'us_register' is 0x026
	us_register EQU 0x026
; 69: 
; 70: Dim i As Byte
;       The address of 'i' is 0x027
	i EQU 0x027
; 71: Dim i_w As Word
;       The address of 'i_w' is 0x028
	i_w EQU 0x028
; 72: Dim ii As Byte
;       The address of 'ii' is 0x02A
	ii EQU 0x02A
; 73: Dim ki As Byte 'variable voor debounce
;       The address of 'ki' is 0x02B
	ki EQU 0x02B
; 74: Dim lt As Byte
;       The address of 'lt' is 0x02C
	lt EQU 0x02C
; 75: Dim prog As Bit
;       The address of 'prog' is 0x014,0
; 76: Dim flag1 As Bit
;       The address of 'flag1' is 0x014,1
; 77: Dim flag2 As Bit
;       The address of 'flag2' is 0x014,2
; 78: Dim clear As Bit
;       The address of 'clear' is 0x014,3
; 79: Dim phase_d As Byte
;       The address of 'phase_d' is 0x02D
	phase_d EQU 0x02D
; 80: Dim phase_tk As Byte
;       The address of 'phase_tk' is 0x02E
	phase_tk EQU 0x02E
; 81: Dim phase_tpn As Byte
;       The address of 'phase_tpn' is 0x02F
	phase_tpn EQU 0x02F
; 82: Dim key As Byte
;       The address of 'key' is 0x030
	key EQU 0x030
; 83: Dim key_t As Byte
;       The address of 'key_t' is 0x031
	key_t EQU 0x031
; 84: Dim c_key1_stap As Byte
;       The address of 'c_key1_stap' is 0x032
	c_key1_stap EQU 0x032
; 85: Dim c_key2_stap As Byte
;       The address of 'c_key2_stap' is 0x033
	c_key2_stap EQU 0x033
; 86: Dim c_key4a As Bit
;       The address of 'c_key4a' is 0x014,4
; 87: Dim home As Bit
;       The address of 'home' is 0x014,5
; 88: Dim tmr1_teller As Byte
;       The address of 'tmr1_teller' is 0x034
	tmr1_teller EQU 0x034
; 89: 
; 90: Symbol key1 = key.0
;       The address of 'key1' is 0x030,0
; 91: Symbol key2 = key.1
;       The address of 'key2' is 0x030,1
; 92: Symbol key3 = key.2
;       The address of 'key3' is 0x030,2
; 93: Symbol key4 = key.3
;       The address of 'key4' is 0x030,3
; 94: Symbol key5 = key.4
;       The address of 'key5' is 0x030,4
; 95: 
; 96: Symbol led1 = PORTC.6
;       The address of 'led1' is 0xF82,6
; 97: Symbol glcd_light = PORTC.2
;       The address of 'glcd_light' is 0xF82,2
; 98: 
; 99: PORTA = 0
	CLRF 0xF80
; 100: PORTB = %00001100
	MOVLW 0x0C
	MOVWF 0xF81
; 101: PORTC = 0
	CLRF 0xF82
; 102: CMCON = 7
	MOVLW 0x07
	MOVWF 0xFB4
; 103: TRISA = 0xff
	MOVLW 0xFF
	MOVWF 0xF92
; 104: TRISB = %11110000
	MOVLW 0xF0
	MOVWF 0xF93
; 105: TRISC = 0
	CLRF 0xF94
; 106: ADCON1 = 0x0e 'set porta1-7 I/O en porta0 analoog
	MOVLW 0x0E
	MOVWF 0xFC1
; 107: CMCON = 0x07 'zet comparators uit
	MOVLW 0x07
	MOVWF 0xFB4
; 108: T0CON = 0x07 'set prescaler 1:256
	MOVLW 0x07
	MOVWF 0xFD5
; 109: INTCON.TMR0IE = 0 'reset TMR0 overflow interrupt bit
	BCF 0xFF2,5
; 110: T1CON = 0xb5
	MOVLW 0xB5
	MOVWF 0xFCD
; 111: 
; 112: prog = 0
	BCF 0x014,0
; 113: flag2 = 0
	BCF 0x014,2
; 114: glcd_light = 0
	BCF 0xF82,2
; 115: c_key4a = 0
	BCF 0x014,4
; 116: 
; 117: EEPROM 02, 0
; 118: EEPROM 04, 1
; 119: EEPROM 06, 0
; 120: 
; 121: 
; 122: GLcdinit
	CLRF 0xF83
	BCF 0xF84,0
	BCF 0xF82,0
	BCF 0xF84,1
	BCF 0xF84,2
	BCF 0xF82,1
	BCF 0xF96,0
	BCF 0xF94,0
	BCF 0xF96,1
	BCF 0xF96,2
	BCF 0xF94,1
	CLRF 0xF95
	BSF 0xF84,1
	BSF 0xF84,2
	MOVLW 0x3F
	CALL GL02
	MOVLW 0x00
	CALL GL10
; 123: Gosub welcome
	CALL L0047
; 124: Gosub loadparameters
	CALL L0045
; 125: Enable High
	BSF INTCON,GIEH											;<------------------------------------------
; 126: 
; 127: newprogram: 
L0001:
; 128: clear = 0
	BCF 0x014,3
; 129: Gosub drawsv
	CALL L0019
; 130: 
; 131: 
; 132: 
; 133: loop: 
L0002:
; 134: If prog = 0 Then
	BTFSC 0x014,0
	GOTO L0050
; 135:  '*********prog1***********
; 136: Gosub lo_batt
	CALL L0026
; 137: flag1 = 0
	BCF 0x014,1
; 138: max = 1
	MOVLW 0x01
	MOVWF 0x021
; 139: tmr1_teller = 50 'aantal keer dat timer1 gereset moet worden
	MOVLW 0x32
	MOVWF 0x034
; 140: TMR1H = 0
	CLRF 0xFCF
; 141: PIR1.TMR1IF = 0
	BCF 0xF9E,0
; 142: PIE1.TMR1IE = 1
	BSF 0xF9D,0
; 143: T1CON.TMR1ON = 1
	BSF 0xFCD,0
; 144: Gosub trig_ch
	CALL L0029
; 145: T1CON.TMR1ON = 0
	BCF 0xFCD,0
; 146: If prog = 1 Then Goto prog2
	BTFSS 0x014,0
	GOTO L0051
	GOTO L0003
L0051:	MOVLB 0x00
; 147: Gosub sound
	CALL L0027
; 148: beginw = 0 'Begin waarde waar mee moet worden begonnen
	CLRF 0x022
	CLRF 0x023
; 149: INTCON.RBIE = 0 'reset RB port change interrupt bit
	BCF 0xFF2,3
; 150: Gosub draws 'wat op het scherm moet komen
	CALL L0017
; 151: INTCON.RBIE = 1 'set RB port change interrupt bit
	BSF 0xFF2,3
; 152: WaitMs 500
	MOVLW 0xF4
	MOVWF R0L
	MOVLW 0x01
	MOVWF R0H
	CALL W001
; 153: Goto loop
	GOTO L0002
; 154: 
; 155: Endif
L0050:	MOVLB 0x00
; 156:  '*********prog2***********
; 157: 
; 158: prog2: 
L0003:
; 159: T1CON.TMR1ON = 0
	BCF 0xFCD,0
; 160: Gosub lo_batt
	CALL L0026
; 161: Gosub c_key3_d
	CALL L0014
; 162: Gosub drawsv2
	CALL L0020
; 163: beginw = 0
	CLRF 0x022
	CLRF 0x023
; 164: l1: 
L0004:
; 165: flag1 = 0
	BCF 0x014,1
; 166: max = 4 'maximaal aantal samples invoeren
	MOVLW 0x04
	MOVWF 0x021
; 167: GLcdposition 15, 57
	MOVLW 0x0F
	MOVWF R3L
	MOVLW 0x39
	MOVWF R3H
	CALL GL30
; 168: GLcdwrite "R"
	MOVLW 0x52
	CALL GW00
; 169: INTCON.RBIE = 1 'set RB port change interrupt bit
	BSF 0xFF2,3
; 170: Gosub trig_ch
	CALL L0029
; 171: 
; 172: If clear = 1 Then Goto l4
	BTFSS 0x014,3
	GOTO L0052
	GOTO L0007
L0052:	MOVLB 0x00
; 173: INTCON.RBIE = 0 'reset RB port change interrupt bit
	BCF 0xFF2,3
; 174: GLcdposition 15, 57
	MOVLW 0x0F
	MOVWF R3L
	MOVLW 0x39
	MOVWF R3H
	CALL GL30
; 175: GLcdwrite "S"
	MOVLW 0x53
	CALL GW00
; 176: Gosub sound
	CALL L0027
; 177: If home = 1 Then 'als de bit home geset is, Ga naar home
	BTFSS 0x014,5
	GOTO L0053
; 178: Gosub clear_cursor
	CALL L0021
; 179: home = 0
	BCF 0x014,5
; 180: beginw = 0
	CLRF 0x022
	CLRF 0x023
; 181: Endif
L0053:	MOVLB 0x00
; 182: l2: 
L0005:
; 183: Gosub draws
	CALL L0017
; 184: Gosub cursor
	CALL L0022
; 185: l3: 
L0006:
; 186: Gosub getkey
	CALL L0015
; 187: If clear = 1 Then Goto l4
	BTFSS 0x014,3
	GOTO L0054
	GOTO L0007
L0054:	MOVLB 0x00
; 188: If key1 = 0 Then c_key1_stap = 0
	BTFSC 0x030,0
	GOTO L0055
	CLRF 0x032
L0055:	MOVLB 0x00
; 189: If key2 = 0 Then c_key2_stap = 0
	BTFSC 0x030,1
	GOTO L0056
	CLRF 0x033
L0056:	MOVLB 0x00
; 190: If key = 0 Then Goto l3
	MOVF 0x030,W
	SUBLW 0x00
	BTFSS STATUS,Z
	GOTO L0057
	GOTO L0006
L0057:	MOVLB 0x00
; 191: Gosub select2
	CALL L0009
; 192: If c_key4a = 1 Then
	BTFSS 0x014,4
	GOTO L0058
; 193: c_key4a = 0
	BCF 0x014,4
; 194: Goto l1
	GOTO L0004
; 195: Endif
L0058:	MOVLB 0x00
; 196: Goto l2
	GOTO L0005
; 197: l4: 
L0007:
; 198: prog = 0
	BCF 0x014,0
; 199: Goto newprogram
	GOTO L0001
; 200: 
; 201: End
L0059:	BRA L0059
; 202: 
; 203: select1: 
L0008:
; 204: 
; 205: Gosub getkey
	CALL L0015
; 206: 
; 207: If key1 = 1 Then 'stel divide tijd in
	BTFSS 0x030,0
	GOTO L0060
; 208: phase_d = phase_d + 1
	MOVF 0x02D,W
	ADDLW 0x01
	MOVWF 0x02D
; 209: If phase_d > 9 Then phase_d = 0
	MOVF 0x02D,W
	SUBLW 0x09
	BTFSC STATUS,C
	GOTO L0061
	CLRF 0x02D
L0061:	MOVLB 0x00
; 210: Gosub c_key1_d
	CALL L0012
; 211: Write 01, phase_d
	MOVLW 0x01
	MOVWF EEADR
	MOVF 0x02D,W
	MOVWF EEDATA
	BCF EECON1,EEPGD
	BCF EECON1,CFGS
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
L0062:	BTFSC EECON1,WR
	BRA L0062
	BCF EECON1,WREN
	BCF PIR2,EEIF
; 212: Endif
L0060:	MOVLB 0x00
; 213: 
; 214: If key2 = 1 Then 'stel trigger kanaal in
	BTFSS 0x030,1
	GOTO L0063
; 215: phase_tk = phase_tk + 1
	MOVF 0x02E,W
	ADDLW 0x01
	MOVWF 0x02E
; 216: If phase_tk > 4 Then
	MOVF 0x02E,W
	SUBLW 0x04
	BTFSC STATUS,C
	GOTO L0064
; 217: phase_tk = 1
	MOVLW 0x01
	MOVWF 0x02E
; 218: Gosub c_key3_d
	CALL L0014
; 219: Endif
L0064:	MOVLB 0x00
; 220: Gosub c_key2_d
	CALL L0013
; 221: Write 02, phase_tk
	MOVLW 0x02
	MOVWF EEADR
	MOVF 0x02E,W
	MOVWF EEDATA
	BCF EECON1,EEPGD
	BCF EECON1,CFGS
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
L0065:	BTFSC EECON1,WR
	BRA L0065
	BCF EECON1,WREN
	BCF PIR2,EEIF
; 222: Endif
L0063:	MOVLB 0x00
; 223: 
; 224: If key3 = 1 Then 'stel trigger op pos. of neg. flank in
	BTFSS 0x030,2
	GOTO L0066
; 225: phase_tpn = phase_tpn + 1
	MOVF 0x02F,W
	ADDLW 0x01
	MOVWF 0x02F
; 226: If phase_tpn > 1 Then phase_tpn = 0
	MOVF 0x02F,W
	SUBLW 0x01
	BTFSC STATUS,C
	GOTO L0067
	CLRF 0x02F
L0067:	MOVLB 0x00
; 227: Gosub c_key3_d
	CALL L0014
; 228: Write 03, phase_tpn
	MOVLW 0x03
	MOVWF EEADR
	MOVF 0x02F,W
	MOVWF EEDATA
	BCF EECON1,EEPGD
	BCF EECON1,CFGS
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
L0068:	BTFSC EECON1,WR
	BRA L0068
	BCF EECON1,WREN
	BCF PIR2,EEIF
; 229: Endif
L0066:	MOVLB 0x00
; 230: 
; 231: If key4 = 1 Then
	BTFSS 0x030,3
	GOTO L0069
; 232: prog = 1
	BSF 0x014,0
; 233: flag2 = 1
	BSF 0x014,2
; 234: Endif
L0069:	MOVLB 0x00
; 235: 
; 236: Gosub debounce
	CALL L0016
; 237: Return
	RETURN
; 238: 
; 239: select2: 
L0009:
; 240: 
; 241: Gosub getkey
	CALL L0015
; 242: 
; 243: If key1 = 1 Then 'verschuif scherm naar links
	BTFSS 0x030,0
	GOTO L0070
; 244: If c_key1_stap < 10 Then c_key1_stap = c_key1_stap + 1
	MOVLW 0x0A
	SUBWF 0x032,W
	BTFSC STATUS,C
	GOTO L0071
	MOVF 0x032,W
	ADDLW 0x01
	MOVWF 0x032
L0071:	MOVLB 0x00
; 245: ASM:        movf c_key1_stap,W
	       movf c_key1_stap,W
; 246: ASM:        subwf beginw,f 'Verlaag low byte van beginw met 1
	       subwf beginw,f
; 247: ASM:        clrf wreg
	       clrf wreg
; 248: ASM:        btfss status,c
	       btfss status,c
; 249: ASM:        addlw 0x01
	       addlw 0x01
; 250: ASM:        subwf beginw + 1,f 'Verlaag high byte van beginw met 1
	       subwf beginw + 1,f
; 251: ASM:        btfss status,n
	       btfss status,n
; 252: Goto sel001
	GOTO L0010
; 253: beginw = 0
	CLRF 0x022
	CLRF 0x023
; 254: sel001: 
L0010:
; 255: Endif
L0070:	MOVLB 0x00
; 256: 
; 257: If key2 = 1 Then 'verschuif scherm naar rechts
	BTFSS 0x030,1
	GOTO L0072
; 258: If c_key2_stap < 10 Then c_key2_stap = c_key2_stap + 1
	MOVLW 0x0A
	SUBWF 0x033,W
	BTFSC STATUS,C
	GOTO L0073
	MOVF 0x033,W
	ADDLW 0x01
	MOVWF 0x033
L0073:	MOVLB 0x00
; 259: beginw = beginw + c_key2_stap
	MOVF 0x022,W
	ADDWF 0x033,W
	MOVWF 0x022
	MOVF 0x023,W
	BTFSC STATUS,C
	ADDLW 0x01
	ADDLW 0x00
	MOVWF 0x023
; 260: If beginw > 895 Then
	MOVF 0x022,W
	MOVWF R0L
	MOVF 0x023,W
	MOVWF R0H
	MOVLW 0x03
	MOVWF R1H
	MOVLW 0x7F
	CALL C003
	BTFSS STATUS,Z
	GOTO L0074
; 261: beginw = 895
	MOVLW 0x7F
	MOVWF 0x022
	MOVLW 0x03
	MOVWF 0x023
; 262: Endif
L0074:	MOVLB 0x00
; 263: Endif
L0072:	MOVLB 0x00
; 264: 
; 265: If key3 = 1 Then 'stel trigger op pos. of neg. flank in
	BTFSS 0x030,2
	GOTO L0075
; 266: phase_tpn = phase_tpn + 1
	MOVF 0x02F,W
	ADDLW 0x01
	MOVWF 0x02F
; 267: If phase_tpn > 1 Then phase_tpn = 0
	MOVF 0x02F,W
	SUBLW 0x01
	BTFSC STATUS,C
	GOTO L0076
	CLRF 0x02F
L0076:	MOVLB 0x00
; 268: Gosub c_key3_d
	CALL L0014
; 269: Gosub debounce
	CALL L0016
; 270: Endif
L0075:	MOVLB 0x00
; 271: 
; 272: ki = 0
	CLRF 0x02B
; 273: k4_: 
L0011:
; 274: If key4 = 1 Then
	BTFSS 0x030,3
	GOTO L0077
; 275: c_key4a = 1
	BSF 0x014,4
; 276: ki = ki + 1
	MOVF 0x02B,W
	ADDLW 0x01
	MOVWF 0x02B
; 277: WaitMs 10
	MOVLW 0x0A
	MOVWF R0L
	CLRF R0H
	CALL W001
; 278: If ki = 100 Then 'Ga in prog2 naar home
	MOVF 0x02B,W
	SUBLW 0x64
	BTFSS STATUS,Z
	GOTO L0078
; 279: home = 1
	BSF 0x014,5
; 280: Gosub sound2
	CALL L0028
; 281: Endif
L0078:	MOVLB 0x00
; 282: If ki < 200 Then
	MOVLW 0xC8
	SUBWF 0x02B,W
	BTFSC STATUS,C
	GOTO L0079
; 283: Gosub getkey
	CALL L0015
; 284: Goto k4_
	GOTO L0011
; 285: Else
	GOTO L0080
L0079:	MOVLB 0x00
; 286: clear = 1 'ga terug naar continu in- en uitlezen
	BSF 0x014,3
; 287: Gosub sound2
	CALL L0028
; 288: WaitMs 200
	MOVLW 0xC8
	MOVWF R0L
	CLRF R0H
	CALL W001
; 289: Gosub sound2
	CALL L0028
; 290: Gosub debounce
	CALL L0016
; 291: 
; 292: Endif
L0080:	MOVLB 0x00
; 293: Endif
L0077:	MOVLB 0x00
; 294: 
; 295: 
; 296: Return
	RETURN
; 297: 
; 298: c_key1_d: 
L0012:
; 299: GLcdposition 7, 0
	MOVLW 0x07
	MOVWF R3L
	MOVLW 0x00
	MOVWF R3H
	CALL GL30
; 300: If phase_d = 0 Then
	MOVF 0x02D,W
	SUBLW 0x00
	BTFSS STATUS,Z
	GOTO L0081
; 301: GLcdwrite "  5"
	MOVLW 0x20
	CALL GW00
	MOVLW 0x20
	CALL GW00
	MOVLW 0x35
	CALL GW00
; 302: Gosub char_u
	CALL L0046
; 303: Endif
L0081:	MOVLB 0x00
; 304: If phase_d = 1 Then
	MOVF 0x02D,W
	SUBLW 0x01
	BTFSS STATUS,Z
	GOTO L0082
; 305: GLcdwrite " 10"
	MOVLW 0x20
	CALL GW00
	MOVLW 0x31
	CALL GW00
	MOVLW 0x30
	CALL GW00
; 306: Gosub char_u
	CALL L0046
; 307: Endif
L0082:	MOVLB 0x00
; 308: If phase_d = 2 Then
	MOVF 0x02D,W
	SUBLW 0x02
	BTFSS STATUS,Z
	GOTO L0083
; 309: GLcdwrite " 20"
	MOVLW 0x20
	CALL GW00
	MOVLW 0x32
	CALL GW00
	MOVLW 0x30
	CALL GW00
; 310: Gosub char_u
	CALL L0046
; 311: Endif
L0083:	MOVLB 0x00
; 312: If phase_d = 3 Then
	MOVF 0x02D,W
	SUBLW 0x03
	BTFSS STATUS,Z
	GOTO L0084
; 313: GLcdwrite " 50"
	MOVLW 0x20
	CALL GW00
	MOVLW 0x35
	CALL GW00
	MOVLW 0x30
	CALL GW00
; 314: Gosub char_u
	CALL L0046
; 315: Endif
L0084:	MOVLB 0x00
; 316: If phase_d = 4 Then
	MOVF 0x02D,W
	SUBLW 0x04
	BTFSS STATUS,Z
	GOTO L0085
; 317: GLcdwrite "100"
	MOVLW 0x31
	CALL GW00
	MOVLW 0x30
	CALL GW00
	MOVLW 0x30
	CALL GW00
; 318: Gosub char_u
	CALL L0046
; 319: Endif
L0085:	MOVLB 0x00
; 320: If phase_d = 5 Then
	MOVF 0x02D,W
	SUBLW 0x05
	BTFSS STATUS,Z
	GOTO L0086
; 321: GLcdwrite "200"
	MOVLW 0x32
	CALL GW00
	MOVLW 0x30
	CALL GW00
	MOVLW 0x30
	CALL GW00
; 322: Gosub char_u
	CALL L0046
; 323: Endif
L0086:	MOVLB 0x00
; 324: If phase_d = 6 Then
	MOVF 0x02D,W
	SUBLW 0x06
	BTFSS STATUS,Z
	GOTO L0087
; 325: GLcdwrite "500"
	MOVLW 0x35
	CALL GW00
	MOVLW 0x30
	CALL GW00
	MOVLW 0x30
	CALL GW00
; 326: Gosub char_u
	CALL L0046
; 327: Endif
L0087:	MOVLB 0x00
; 328: If phase_d = 7 Then GLcdwrite "  1m"
	MOVF 0x02D,W
	SUBLW 0x07
	BTFSS STATUS,Z
	GOTO L0088
	MOVLW 0x20
	CALL GW00
	MOVLW 0x20
	CALL GW00
	MOVLW 0x31
	CALL GW00
	MOVLW 0x6D
	CALL GW00
L0088:	MOVLB 0x00
; 329: If phase_d = 8 Then GLcdwrite "  2m"
	MOVF 0x02D,W
	SUBLW 0x08
	BTFSS STATUS,Z
	GOTO L0089
	MOVLW 0x20
	CALL GW00
	MOVLW 0x20
	CALL GW00
	MOVLW 0x32
	CALL GW00
	MOVLW 0x6D
	CALL GW00
L0089:	MOVLB 0x00
; 330: If phase_d = 9 Then GLcdwrite "  5m"
	MOVF 0x02D,W
	SUBLW 0x09
	BTFSS STATUS,Z
	GOTO L0090
	MOVLW 0x20
	CALL GW00
	MOVLW 0x20
	CALL GW00
	MOVLW 0x35
	CALL GW00
	MOVLW 0x6D
	CALL GW00
L0090:	MOVLB 0x00
; 331: Return
	RETURN
; 332: 
; 333: c_key2_d: 
L0013:
; 334: GLcdposition 15, 36
	MOVLW 0x0F
	MOVWF R3L
	MOVLW 0x24
	MOVWF R3H
	CALL GL30
; 335: GLcdwrite #phase_tk
	MOVF 0x02E,W
	MOVWF R2L
	CLRF R2H
	CALL GL61
; 336: Return
	RETURN
; 337: 
; 338: c_key3_d: 
L0014:
; 339: GLcdposition 15, 24
	MOVLW 0x0F
	MOVWF R3L
	MOVLW 0x18
	MOVWF R3H
	CALL GL30
; 340: GLcdwrite "ch"
	MOVLW 0x63
	CALL GW00
	MOVLW 0x68
	CALL GW00
; 341: Gosub c_key2_d
	CALL L0013
; 342: If phase_tpn = 0 Then GLcdwrite "-" Else GLcdwrite "+"
	MOVF 0x02F,W
	SUBLW 0x00
	BTFSS STATUS,Z
	GOTO L0091
	MOVLW 0x2D
	CALL GW00
	GOTO L0092
L0091:	MOVLB 0x00
	MOVLW 0x2B
	CALL GW00
L0092:	MOVLB 0x00
; 343: Return
	RETURN
; 344: 
; 345: getkey: 
L0015:
; 346: key = 0
	CLRF 0x030
; 347: PORTB.2 = 1
	BSF 0xF81,2
; 348: PORTB.3 = 0
	BCF 0xF81,3
; 349: WaitUs 1
	MOVLW 0x01
	MOVWF R4L
	CALL X001
; 350: key = PORTB And %11110000
	MOVF 0xF81,W
	MOVWF R0L
	MOVLW 0xF0
	ANDWF R0L,W
	MOVWF 0x030
; 351: ASM:        swapf key,F
	       swapf key,F
; 352: PORTB.2 = 0
	BCF 0xF81,2
; 353: PORTB.3 = 1
	BSF 0xF81,3
; 354: WaitMs 1
	MOVLW 0x01
	MOVWF R0L
	CLRF R0H
	CALL W001
; 355: key_t = PORTB And %11110000
	MOVF 0xF81,W
	MOVWF R0L
	MOVLW 0xF0
	ANDWF R0L,W
	MOVWF 0x031
; 356: key = key_t Or key
	MOVF 0x031,W
	MOVWF R0L
	MOVF 0x030,W
	IORWF R0L,W
	MOVWF 0x030
; 357: PORTB.2 = 1
	BSF 0xF81,2
; 358: 
; 359: If key5 = 1 Then
	BTFSS 0x030,4
	GOTO L0093
; 360: Toggle glcd_light
	BCF TRISC,2
	BTG LATC,2
; 361: lt = 0
	CLRF 0x02C
; 362: TMR0H = 0 'Reset TMR0H register
	CLRF 0xFD7
; 363: T0CON.TMR0ON = 1 'Set TMR0 aan
	BSF 0xFD5,7
; 364: INTCON.TMR0IF = 0 'Reset TMR0 overflow interrupt flag bit
	BCF 0xFF2,2
; 365: INTCON.TMR0IE = 1 'Set TMR0 overflow interrupt bit
	BSF 0xFF2,5
; 366: Gosub debounce
	CALL L0016
; 367: Endif
L0093:	MOVLB 0x00
; 368: 
; 369: Return
	RETURN
; 370: 
; 371: debounce: 
L0016:
; 372: PORTB.2 = 1
	BSF 0xF81,2
; 373: PORTB.3 = 1
	BSF 0xF81,3
; 374: key_t = PORTB And %11110000
	MOVF 0xF81,W
	MOVWF R0L
	MOVLW 0xF0
	ANDWF R0L,W
	MOVWF 0x031
; 375: If key_t > 0 Then ki = 0
	MOVF 0x031,W
	SUBLW 0x00
	BTFSC STATUS,C
	GOTO L0094
	CLRF 0x02B
L0094:	MOVLB 0x00
; 376: ki = ki + 1
	MOVF 0x02B,W
	ADDLW 0x01
	MOVWF 0x02B
; 377: WaitMs 10
	MOVLW 0x0A
	MOVWF R0L
	CLRF R0H
	CALL W001
; 378: If ki < 10 Then Goto debounce
	MOVLW 0x0A
	SUBWF 0x02B,W
	BTFSC STATUS,C
	GOTO L0095
	GOTO L0016
L0095:	MOVLB 0x00
; 379: Return
	RETURN
; 380: 
; 381: draws:  'Schrijf 128 monsters op display
L0017:
; 382:  'sample_2 = sample(beginw)
; 383: FSR1H = beginw.HB + 1
	MOVF 0x023,W
	ADDLW 0x01
	MOVWF 0xFE2
; 384: If beginw > 0 Then FSR1L = beginw.LB - 1 Else FSR1L = beginw.LB
	MOVF 0x022,W
	MOVWF R0L
	MOVF 0x023,W
	MOVWF R0H
	CLRF R1H
	MOVLW 0x00
	CALL C003
	BTFSS STATUS,Z
	GOTO L0096
	MOVLW 0x01
	SUBWF 0x022,W
	MOVWF 0xFE1
	GOTO L0097
L0096:	MOVLB 0x00
	MOVF 0x022,W
	MOVWF 0xFE1
L0097:	MOVLB 0x00
; 385: sample_2 = INDF1
	MOVF 0xFE7,W
	MOVWF 0x020
; 386: 
; 387:  'sample_1 = sample(i)
; 388: FSR1H = beginw.HB + 1
	MOVF 0x023,W
	ADDLW 0x01
	MOVWF 0xFE2
; 389: FSR1L = beginw.LB
	MOVF 0x022,W
	MOVWF 0xFE1
; 390: 
; 391: For y = 0 To 127
	CLRF 0x018
L0098:
	MOVF 0x018,W
	SUBLW 0x7F
	BTFSS STATUS,C
	GOTO L0099
; 392: ASM:        movff postinc1,sample_1
	       movff postinc1,sample_1
; 393: temp = sample_1 'Maak copy van sample_1
	MOVF 0x01F,W
	MOVWF 0x025
; 394: Gosub draw
	CALL L0018
; 395: Next y
	MOVLW 0x01
	ADDWF 0x018,F
	BTFSS STATUS,C
	GOTO L0098
L0099:	MOVLB 0x00
; 396: Return
	RETURN
; 397: 
; 398: draw:  'Schrijf een reeks samples op display
L0018:
; 399: For ii = 39 To 3 Step -12
	MOVLW 0x27
	MOVWF 0x02A
L0100:
	MOVLW 0x03
	SUBWF 0x02A,W
	BTFSS STATUS,C
	GOTO L0101
; 400: If sample_1.1 <> sample_2.1 Then
	CLRF WREG
	BTFSC 0x01F,1
	ADDLW 0x01
	BTFSC 0x020,1
	SUBLW 0x01
	BTFSC STATUS,Z
	GOTO L0102
; 401: For xx = 0 To 8
	CLRF 0x01B
L0103:
	MOVF 0x01B,W
	SUBLW 0x08
	BTFSS STATUS,C
	GOTO L0104
; 402: x = ii + xx
	MOVF 0x02A,W
	ADDWF 0x01B,W
	MOVWF 0x01A
; 403: GLcdpset y, x
	MOVF 0x018,W
	MOVWF R3L
	MOVF 0x01A,W
	MOVWF R3H
	CALL GL20
; 404: Next xx
	MOVLW 0x01
	ADDWF 0x01B,F
	BTFSS STATUS,C
	GOTO L0103
L0104:	MOVLB 0x00
; 405: Else
	GOTO L0105
L0102:	MOVLB 0x00
; 406: If sample_1.1 = True Then
	BTFSS 0x01F,1
	GOTO L0106
; 407: For xx = 0 To 7
	CLRF 0x01B
L0107:
	MOVF 0x01B,W
	SUBLW 0x07
	BTFSS STATUS,C
	GOTO L0108
; 408: x = ii + xx
	MOVF 0x02A,W
	ADDWF 0x01B,W
	MOVWF 0x01A
; 409: GLcdpreset y, x
	MOVF 0x018,W
	MOVWF R3L
	MOVF 0x01A,W
	MOVWF R3H
	CALL GL40
; 410: Next xx
	MOVLW 0x01
	ADDWF 0x01B,F
	BTFSS STATUS,C
	GOTO L0107
L0108:	MOVLB 0x00
; 411: x = x + 1
	MOVF 0x01A,W
	ADDLW 0x01
	MOVWF 0x01A
; 412: GLcdpset y, x
	MOVF 0x018,W
	MOVWF R3L
	MOVF 0x01A,W
	MOVWF R3H
	CALL GL20
; 413: Else
	GOTO L0109
L0106:	MOVLB 0x00
; 414: GLcdpset y, ii
	MOVF 0x018,W
	MOVWF R3L
	MOVF 0x02A,W
	MOVWF R3H
	CALL GL20
; 415: For xx = 1 To 8
	MOVLW 0x01
	MOVWF 0x01B
L0110:
	MOVF 0x01B,W
	SUBLW 0x08
	BTFSS STATUS,C
	GOTO L0111
; 416: x = ii + xx
	MOVF 0x02A,W
	ADDWF 0x01B,W
	MOVWF 0x01A
; 417: GLcdpreset y, x
	MOVF 0x018,W
	MOVWF R3L
	MOVF 0x01A,W
	MOVWF R3H
	CALL GL40
; 418: Next xx
	MOVLW 0x01
	ADDWF 0x01B,F
	BTFSS STATUS,C
	GOTO L0110
L0111:	MOVLB 0x00
; 419: Endif
L0109:	MOVLB 0x00
; 420: Endif
L0105:	MOVLB 0x00
; 421: ASM:        rrncf sample_1,f
	       rrncf sample_1,f
; 422: ASM:        rrncf sample_2,f
	       rrncf sample_2,f
; 423: Next ii
	MOVLW 0x0C
	SUBWF 0x02A,F
	BTFSC STATUS,C
	GOTO L0100
L0101:	MOVLB 0x00
; 424: sample_2 = temp 'laad sample_2 met de copy van sample_1
	MOVF 0x025,W
	MOVWF 0x020
; 425: Return
	RETURN
; 426: 
; 427: drawsv:  'Schrijf schaal verdeling op display
L0019:
; 428: INTCON.RBIE = 0
	BCF 0xFF2,3
; 429: GLcdclear
	MOVLW 0x00
	CALL GL10
; 430: For y = 0 To 127 Step 2
	CLRF 0x018
L0112:
	MOVF 0x018,W
	SUBLW 0x7F
	BTFSS STATUS,C
	GOTO L0113
; 431: GLcdpset y, 0
	MOVF 0x018,W
	MOVWF R3L
	MOVLW 0x00
	MOVWF R3H
	CALL GL20
; 432: GLcdpset y, 50
	MOVF 0x018,W
	MOVWF R3L
	MOVLW 0x32
	MOVWF R3H
	CALL GL20
; 433: Next y
	MOVLW 0x02
	ADDWF 0x018,F
	BTFSS STATUS,C
	GOTO L0112
L0113:	MOVLB 0x00
; 434: For y = 0 To 120 Step 10
	CLRF 0x018
L0114:
	MOVF 0x018,W
	SUBLW 0x78
	BTFSS STATUS,C
	GOTO L0115
; 435: GLcdpset y, 1
	MOVF 0x018,W
	MOVWF R3L
	MOVLW 0x01
	MOVWF R3H
	CALL GL20
; 436: GLcdpset y, 49
	MOVF 0x018,W
	MOVWF R3L
	MOVLW 0x31
	MOVWF R3H
	CALL GL20
; 437: Next y
	MOVLW 0x0A
	ADDWF 0x018,F
	BTFSS STATUS,C
	GOTO L0114
L0115:	MOVLB 0x00
; 438: Gosub c_key1_d
	CALL L0012
; 439: GLcdwrite "S/DIV"
	MOVLW 0x53
	CALL GW00
	MOVLW 0x2F
	CALL GW00
	MOVLW 0x44
	CALL GW00
	MOVLW 0x49
	CALL GW00
	MOVLW 0x56
	CALL GW00
; 440: GLcdposition 7, 58
	MOVLW 0x07
	MOVWF R3L
	MOVLW 0x3A
	MOVWF R3H
	CALL GL30
; 441: GLcdwrite "t"
	MOVLW 0x74
	CALL GW00
; 442: GLcdposition 15, 0
	MOVLW 0x0F
	MOVWF R3L
	MOVLW 0x00
	MOVWF R3H
	CALL GL30
; 443: GLcdwrite "rig."
	MOVLW 0x72
	CALL GW00
	MOVLW 0x69
	CALL GW00
	MOVLW 0x67
	CALL GW00
	MOVLW 0x2E
	CALL GW00
; 444: Gosub c_key3_d
	CALL L0014
; 445: INTCON.RBIE = 1
	BSF 0xFF2,3
; 446: Return
	RETURN
; 447: 
; 448: drawsv2: 
L0020:
; 449: GLcdclean 7
	MOVLW 0x07
	MOVWF R3L
	MOVLW 0x00
	MOVWF R3H
	CALL GL30
	MOVLW 0x00
	MOVWF R3L
	MOVLW 0x3F
	MOVWF R3H
	CALL GL50
; 450: GLcdposition 7, 10
	MOVLW 0x07
	MOVWF R3L
	MOVLW 0x0A
	MOVWF R3H
	CALL GL30
; 451: GLcdwrite "<-   -> t"
	MOVLW 0x3C
	CALL GW00
	MOVLW 0x2D
	CALL GW00
	MOVLW 0x20
	CALL GW00
	MOVLW 0x20
	CALL GW00
	MOVLW 0x20
	CALL GW00
	MOVLW 0x2D
	CALL GW00
	MOVLW 0x3E
	CALL GW00
	MOVLW 0x20
	CALL GW00
	MOVLW 0x74
	CALL GW00
; 452: Return
	RETURN
; 453: 
; 454: clear_cursor: 
L0021:
; 455: For y = 0 To 128
	CLRF 0x018
L0116:
	MOVF 0x018,W
	SUBLW 0x80
	BTFSS STATUS,C
	GOTO L0117
; 456: GLcdpreset y, 52
	MOVF 0x018,W
	MOVWF R3L
	MOVLW 0x34
	MOVWF R3H
	CALL GL40
; 457: GLcdpreset y, 53
	MOVF 0x018,W
	MOVWF R3L
	MOVLW 0x35
	MOVWF R3H
	CALL GL40
; 458: Next y
	MOVLW 0x01
	ADDWF 0x018,F
	BTFSS STATUS,C
	GOTO L0116
L0117:	MOVLB 0x00
; 459: Return
	RETURN
; 460: 
; 461: cursor: 
L0022:
; 462: If beginw < 4 Then cursor_pos = 0 Else cursor_pos = beginw / 7
	MOVF 0x022,W
	MOVWF R0L
	MOVF 0x023,W
	MOVWF R0H
	CLRF R1H
	MOVLW 0x04
	CALL C004
	BTFSS STATUS,Z
	GOTO L0118
	CLRF 0x024
	GOTO L0119
L0118:	MOVLB 0x00
;       The address of 'oshonsoft_temp_1' is 0x035
	oshonsoft_temp_1 EQU 0x035
	MOVF 0x022,W
	MOVWF R0L
	MOVF 0x023,W
	MOVWF R0H
	MOVLW 0x07
	MOVWF R1L
	CLRF R1H
	CALL D001
	MOVWF 0x035
	MOVF R0H,W
	MOVWF 0x036
	MOVF 0x035,W
	MOVWF 0x024
L0119:	MOVLB 0x00
; 463: 
; 464: cur001: 
L0023:
; 465: If cursor_pos < 2 Then
	MOVLW 0x02
	SUBWF 0x024,W
	BTFSC STATUS,C
	GOTO L0120
; 466: For y = 0 To 2
	CLRF 0x018
L0121:
	MOVF 0x018,W
	SUBLW 0x02
	BTFSS STATUS,C
	GOTO L0122
; 467: GLcdpset y, 52
	MOVF 0x018,W
	MOVWF R3L
	MOVLW 0x34
	MOVWF R3H
	CALL GL20
; 468: GLcdpset y, 53
	MOVF 0x018,W
	MOVWF R3L
	MOVLW 0x35
	MOVWF R3H
	CALL GL20
; 469: Next y
	MOVLW 0x01
	ADDWF 0x018,F
	BTFSS STATUS,C
	GOTO L0121
L0122:	MOVLB 0x00
; 470: For i = 0 To 4
	CLRF 0x027
L0123:
	MOVF 0x027,W
	SUBLW 0x04
	BTFSS STATUS,C
	GOTO L0124
; 471: GLcdpreset y, 52
	MOVF 0x018,W
	MOVWF R3L
	MOVLW 0x34
	MOVWF R3H
	CALL GL40
; 472: GLcdpreset y, 53
	MOVF 0x018,W
	MOVWF R3L
	MOVLW 0x35
	MOVWF R3H
	CALL GL40
; 473: ASM:        incf y,F
	       incf y,F
; 474: Next i
	MOVLW 0x01
	ADDWF 0x027,F
	BTFSS STATUS,C
	GOTO L0123
L0124:	MOVLB 0x00
; 475: Else
	GOTO L0125
L0120:	MOVLB 0x00
; 476: y = cursor_pos - 2
	MOVLW 0x02
	SUBWF 0x024,W
	MOVWF 0x018
; 477: For i = 0 To 4
	CLRF 0x027
L0126:
	MOVF 0x027,W
	SUBLW 0x04
	BTFSS STATUS,C
	GOTO L0127
; 478: GLcdpreset y, 52
	MOVF 0x018,W
	MOVWF R3L
	MOVLW 0x34
	MOVWF R3H
	CALL GL40
; 479: GLcdpreset y, 53
	MOVF 0x018,W
	MOVWF R3L
	MOVLW 0x35
	MOVWF R3H
	CALL GL40
; 480: ASM:        decf y,F
	       decf y,F
; 481: ASM:        btfsc status,n
	       btfsc status,n
; 482: Goto cur1
	GOTO L0024
; 483: Next i
	MOVLW 0x01
	ADDWF 0x027,F
	BTFSS STATUS,C
	GOTO L0126
L0127:	MOVLB 0x00
; 484: cur1: 
L0024:
; 485: y = cursor_pos - 1
	MOVLW 0x01
	SUBWF 0x024,W
	MOVWF 0x018
; 486: If y > 125 Then y = 125
	MOVF 0x018,W
	SUBLW 0x7D
	BTFSC STATUS,C
	GOTO L0128
	MOVLW 0x7D
	MOVWF 0x018
L0128:	MOVLB 0x00
; 487: For i = 0 To 2
	CLRF 0x027
L0129:
	MOVF 0x027,W
	SUBLW 0x02
	BTFSS STATUS,C
	GOTO L0130
; 488: GLcdpset y, 52
	MOVF 0x018,W
	MOVWF R3L
	MOVLW 0x34
	MOVWF R3H
	CALL GL20
; 489: GLcdpset y, 53
	MOVF 0x018,W
	MOVWF R3L
	MOVLW 0x35
	MOVWF R3H
	CALL GL20
; 490: ASM:        incf y,F
	       incf y,F
; 491: Next i
	MOVLW 0x01
	ADDWF 0x027,F
	BTFSS STATUS,C
	GOTO L0129
L0130:	MOVLB 0x00
; 492: For i = 0 To 4
	CLRF 0x027
L0131:
	MOVF 0x027,W
	SUBLW 0x04
	BTFSS STATUS,C
	GOTO L0132
; 493: If y > 127 Then Goto cur2
	MOVF 0x018,W
	SUBLW 0x7F
	BTFSC STATUS,C
	GOTO L0133
	GOTO L0025
L0133:	MOVLB 0x00
; 494: GLcdpreset y, 52
	MOVF 0x018,W
	MOVWF R3L
	MOVLW 0x34
	MOVWF R3H
	CALL GL40
; 495: GLcdpreset y, 53
	MOVF 0x018,W
	MOVWF R3L
	MOVLW 0x35
	MOVWF R3H
	CALL GL40
; 496: ASM:        incf y,F
	       incf y,F
; 497: Next i
	MOVLW 0x01
	ADDWF 0x027,F
	BTFSS STATUS,C
	GOTO L0131
L0132:	MOVLB 0x00
; 498: Endif
L0125:	MOVLB 0x00
; 499: cur2: 
L0025:
; 500: Return
	RETURN
; 501: 
; 502: 
; 503: 
; 504: lo_batt: 
L0026:
; 505: Adcin 0, an0
	BSF ADCON2,ADFM
	MOVLW 0x00
	MOVWF R0L
	CALL A001
	MOVF ADRESL,W
	MOVWF 0x015
	MOVF ADRESH,W
	MOVWF 0x016
; 506: If an0 < 825 Then
	MOVF 0x015,W
	MOVWF R0L
	MOVF 0x016,W
	MOVWF R0H
	MOVLW 0x03
	MOVWF R1H
	MOVLW 0x39
	CALL C004
	BTFSS STATUS,Z
	GOTO L0134
; 507: GLcdclean 2
	MOVLW 0x02
	MOVWF R3L
	MOVLW 0x00
	MOVWF R3H
	CALL GL30
	MOVLW 0x00
	MOVWF R3L
	MOVLW 0x3F
	MOVWF R3H
	CALL GL50
; 508: GLcdposition 2, 12
	MOVLW 0x02
	MOVWF R3L
	MOVLW 0x0C
	MOVWF R3H
	CALL GL30
; 509: GLcdwrite "Lo-batt"
	MOVLW 0x4C
	CALL GW00
	MOVLW 0x6F
	CALL GW00
	MOVLW 0x2D
	CALL GW00
	MOVLW 0x62
	CALL GW00
	MOVLW 0x61
	CALL GW00
	MOVLW 0x74
	CALL GW00
	MOVLW 0x74
	CALL GW00
; 510: glcd_light = 0
	BCF 0xF82,2
; 511: WaitMs 2000
	MOVLW 0xD0
	MOVWF R0L
	MOVLW 0x07
	MOVWF R0H
	CALL W001
; 512: GLcdclean 2
	MOVLW 0x02
	MOVWF R3L
	MOVLW 0x00
	MOVWF R3H
	CALL GL30
	MOVLW 0x00
	MOVWF R3L
	MOVLW 0x3F
	MOVWF R3H
	CALL GL50
; 513: Endif
L0134:	MOVLB 0x00
; 514: Return
	RETURN
; 515: 
; 516:  '------------- Sound generator ------------
; 517: sound: 
L0027:
; 518: 
; 519: For aa = 0 To 200
	CLRF 0x017
L0135:
	MOVF 0x017,W
	SUBLW 0xC8
	BTFSS STATUS,C
	GOTO L0136
; 520: PORTC.7 = 1
	BSF 0xF82,7
; 521: WaitUs 180
	MOVLW 0xB4
	MOVWF R4L
	CALL X001
; 522: PORTC.7 = 0
	BCF 0xF82,7
; 523: WaitUs 180
	MOVLW 0xB4
	MOVWF R4L
	CALL X001
; 524: Next aa
	MOVLW 0x01
	ADDWF 0x017,F
	BTFSS STATUS,C
	GOTO L0135
L0136:	MOVLB 0x00
; 525: 
; 526: Return
	RETURN
; 527: 
; 528: sound2: 
L0028:
; 529: 
; 530: For aa = 0 To 125
	CLRF 0x017
L0137:
	MOVF 0x017,W
	SUBLW 0x7D
	BTFSS STATUS,C
	GOTO L0138
; 531: PORTC.7 = 1
	BSF 0xF82,7
; 532: WaitUs 220
	MOVLW 0xDC
	MOVWF R4L
	CALL X001
; 533: PORTC.7 = 0
	BCF 0xF82,7
; 534: WaitUs 220
	MOVLW 0xDC
	MOVWF R4L
	CALL X001
; 535: Next aa
	MOVLW 0x01
	ADDWF 0x017,F
	BTFSS STATUS,C
	GOTO L0137
L0138:	MOVLB 0x00
; 536: 
; 537: Return
	RETURN
; 538: 
; 539: trig_ch: 
L0029:
; 540: flag1 = 0
	BCF 0x014,1
; 541: If flag2 = 1 Then 'Is er op key run/stop gedrukt
	BTFSS 0x014,2
	GOTO L0139
; 542: flag2 = 0 'Zo ja, ga naar het begin van het programma
	BCF 0x014,2
; 543: Goto trig_l1
	GOTO L0031
; 544: Endif
L0139:	MOVLB 0x00
; 545: 
; 546: If clear = 1 Then Goto trig_l1
	BTFSS 0x014,3
	GOTO L0140
	GOTO L0031
L0140:	MOVLB 0x00
; 547: 
; 548: ASM:        lfsr fsr0,sample
	       lfsr fsr0,sample
; 549: i = 0xff
	MOVLW 0xFF
	MOVWF 0x027
; 550: 
; 551: 
; 552: If phase_tpn = 0 Then Goto trig_ch_n
	MOVF 0x02F,W
	SUBLW 0x00
	BTFSS STATUS,Z
	GOTO L0141
	GOTO L0032
L0141:	MOVLB 0x00
; 553: If phase_tpn = 1 Then Goto trig_ch_p
	MOVF 0x02F,W
	SUBLW 0x01
	BTFSS STATUS,Z
	GOTO L0142
	GOTO L0030
L0142:	MOVLB 0x00
; 554: 
; 555: trig_ch_p: 
L0030:
; 556: If phase_tk = 1 Then
	MOVF 0x02E,W
	SUBLW 0x01
	BTFSS STATUS,Z
	GOTO L0143
; 557: While PORTA.4 = 0
L0144:
	BTFSC 0xF80,4
	GOTO L0145
; 558: ASM:        btfsc 0x014,1 'Is er op een key gedrukt?
	       btfsc 0x014,1
; 559: Goto trig_ch
	GOTO L0029
; 560: Wend
	GOTO L0144
L0145:	MOVLB 0x00
; 561: While PORTA.4 = 1
L0146:
	BTFSS 0xF80,4
	GOTO L0147
; 562: ASM:        btfsc 0x014,1
	       btfsc 0x014,1
; 563: Goto trig_ch
	GOTO L0029
; 564: Wend
	GOTO L0146
L0147:	MOVLB 0x00
; 565: Goto sample_inv
	GOTO L0033
; 566: Endif
L0143:	MOVLB 0x00
; 567: If phase_tk = 2 Then
	MOVF 0x02E,W
	SUBLW 0x02
	BTFSS STATUS,Z
	GOTO L0148
; 568: While PORTA.3 = 0
L0149:
	BTFSC 0xF80,3
	GOTO L0150
; 569: ASM:        btfsc 0x014,1
	       btfsc 0x014,1
; 570: Goto trig_ch
	GOTO L0029
; 571: Wend
	GOTO L0149
L0150:	MOVLB 0x00
; 572: While PORTA.3 = 1
L0151:
	BTFSS 0xF80,3
	GOTO L0152
; 573: ASM:        btfsc 0x014,1
	       btfsc 0x014,1
; 574: Goto trig_ch
	GOTO L0029
; 575: Wend
	GOTO L0151
L0152:	MOVLB 0x00
; 576: Goto sample_inv
	GOTO L0033
; 577: Endif
L0148:	MOVLB 0x00
; 578: If phase_tk = 3 Then
	MOVF 0x02E,W
	SUBLW 0x03
	BTFSS STATUS,Z
	GOTO L0153
; 579: While PORTA.2 = 0
L0154:
	BTFSC 0xF80,2
	GOTO L0155
; 580: ASM:        btfsc 0x014,1
	       btfsc 0x014,1
; 581: Goto trig_ch
	GOTO L0029
; 582: Wend
	GOTO L0154
L0155:	MOVLB 0x00
; 583: While PORTA.2 = 1
L0156:
	BTFSS 0xF80,2
	GOTO L0157
; 584: ASM:        btfsc 0x014,1
	       btfsc 0x014,1
; 585: Goto trig_ch
	GOTO L0029
; 586: Wend
	GOTO L0156
L0157:	MOVLB 0x00
; 587: Goto sample_inv
	GOTO L0033
; 588: Else
	GOTO L0158
L0153:	MOVLB 0x00
; 589: While PORTA.1 = 0
L0159:
	BTFSC 0xF80,1
	GOTO L0160
; 590: ASM:        btfsc 0x014,1
	       btfsc 0x014,1
; 591: Goto trig_ch
	GOTO L0029
; 592: Wend
	GOTO L0159
L0160:	MOVLB 0x00
; 593: While PORTA.1 = 1
L0161:
	BTFSS 0xF80,1
	GOTO L0162
; 594: ASM:        btfsc 0x014,1
	       btfsc 0x014,1
; 595: Goto trig_ch
	GOTO L0029
; 596: Wend
	GOTO L0161
L0162:	MOVLB 0x00
; 597: Goto sample_inv
	GOTO L0033
; 598: Endif
L0158:	MOVLB 0x00
; 599: trig_l1: 
L0031:
; 600: Return
	RETURN
; 601: 
; 602: trig_ch_n: 
L0032:
; 603: If phase_tk = 1 Then
	MOVF 0x02E,W
	SUBLW 0x01
	BTFSS STATUS,Z
	GOTO L0163
; 604: While PORTA.4 = 1
L0164:
	BTFSS 0xF80,4
	GOTO L0165
; 605: ASM:        btfsc 0x014,1
	       btfsc 0x014,1
; 606: Goto trig_ch
	GOTO L0029
; 607: Wend
	GOTO L0164
L0165:	MOVLB 0x00
; 608: While PORTA.4 = 0
L0166:
	BTFSC 0xF80,4
	GOTO L0167
; 609: ASM:        btfsc 0x014,1
	       btfsc 0x014,1
; 610: Goto trig_ch
	GOTO L0029
; 611: Wend
	GOTO L0166
L0167:	MOVLB 0x00
; 612: Goto sample_inv
	GOTO L0033
; 613: Endif
L0163:	MOVLB 0x00
; 614: If phase_tk = 2 Then
	MOVF 0x02E,W
	SUBLW 0x02
	BTFSS STATUS,Z
	GOTO L0168
; 615: While PORTA.3 = 1
L0169:
	BTFSS 0xF80,3
	GOTO L0170
; 616: ASM:        btfsc 0x014,1
	       btfsc 0x014,1
; 617: Goto trig_ch
	GOTO L0029
; 618: Wend
	GOTO L0169
L0170:	MOVLB 0x00
; 619: While PORTA.3 = 0
L0171:
	BTFSC 0xF80,3
	GOTO L0172
; 620: ASM:        btfsc 0x014,1
	       btfsc 0x014,1
; 621: Goto trig_ch
	GOTO L0029
; 622: Wend
	GOTO L0171
L0172:	MOVLB 0x00
; 623: Goto sample_inv
	GOTO L0033
; 624: Endif
L0168:	MOVLB 0x00
; 625: If phase_tk = 3 Then
	MOVF 0x02E,W
	SUBLW 0x03
	BTFSS STATUS,Z
	GOTO L0173
; 626: While PORTA.2 = 1
L0174:
	BTFSS 0xF80,2
	GOTO L0175
; 627: ASM:        btfsc 0x014,1
	       btfsc 0x014,1
; 628: Goto trig_ch
	GOTO L0029
; 629: Wend
	GOTO L0174
L0175:	MOVLB 0x00
; 630: While PORTA.2 = 0
L0176:
	BTFSC 0xF80,2
	GOTO L0177
; 631: ASM:        btfsc 0x014,1
	       btfsc 0x014,1
; 632: Goto trig_ch
	GOTO L0029
; 633: Wend
	GOTO L0176
L0177:	MOVLB 0x00
; 634: Goto sample_inv
	GOTO L0033
; 635: Else
	GOTO L0178
L0173:	MOVLB 0x00
; 636: While PORTA.1 = 1
L0179:
	BTFSS 0xF80,1
	GOTO L0180
; 637: ASM:        btfsc 0x014,1
	       btfsc 0x014,1
; 638: Goto trig_ch
	GOTO L0029
; 639: Wend
	GOTO L0179
L0180:	MOVLB 0x00
; 640: While PORTA.1 = 0
L0181:
	BTFSC 0xF80,1
	GOTO L0182
; 641: ASM:        btfsc 0x014,1
	       btfsc 0x014,1
; 642: Goto trig_ch
	GOTO L0029
; 643: Wend
	GOTO L0181
L0182:	MOVLB 0x00
; 644: Goto sample_inv
	GOTO L0033
; 645: Endif
L0178:	MOVLB 0x00
; 646: 
; 647: 
; 648:  '__________________________________________________
; 649: 
; 650: sample_inv: 
L0033:
; 651: PIE1.TMR1IE = 0
	BCF 0xF9D,0
; 652:  'If phase_d = 0 Then Goto sample_in1
; 653: ASM:        movf phase_d,w
	       movf phase_d,w
; 654: ASM:        sublw 0x00
	       sublw 0x00
; 655: ASM:        btfss status,z
	       btfss status,z
; 656: Goto sample_in2
	GOTO L0036
; 657: sample_in1:  '5uSec/Div.
L0034:
; 658: 
; 659: s001: 
L0035:
; 660: ASM:        movff porta,postinc0
	       movff porta,postinc0
; 661: ASM:        decfsz i,f
	       decfsz i,f
; 662: Goto s001
	GOTO L0035
; 663: ASM:        decfsz max,f
	       decfsz max,f
; 664: Goto s001
	GOTO L0035
; 665: 
; 666: Return
	RETURN
; 667: 
; 668: sample_in2:  '10uSec/Div
L0036:
; 669: 
; 670:  'If phase_d = 1 Then Goto sample_in2
; 671: ASM:        movf phase_d,w
	       movf phase_d,w
; 672: ASM:        sublw 0x01
	       sublw 0x01
; 673: ASM:        btfss status,z
	       btfss status,z
; 674: Goto sample_in3
	GOTO L0038
; 675: 
; 676: s002: 
L0037:
; 677: 
; 678: ASM:        movff porta,postinc0
	       movff porta,postinc0
; 679: ASM:        nop
	       nop
; 680: ASM:        nop
	       nop
; 681: ASM:        nop
	       nop
; 682: ASM:        nop
	       nop
; 683: ASM:        nop
	       nop
; 684: ASM:        decfsz i,f
	       decfsz i,f
; 685: Goto s002
	GOTO L0037
; 686: ASM:        decfsz max,f
	       decfsz max,f
; 687: Goto s002
	GOTO L0037
; 688: 
; 689: Return
	RETURN
; 690: 
; 691: sample_in3:  '20uSec/div
L0038:
; 692: 
; 693:  'If phase_d = 2 Then Goto sample_in3
; 694: ASM:        movf phase_d,w
	       movf phase_d,w
; 695: ASM:        sublw 0x02
	       sublw 0x02
; 696: ASM:        btfss status,z
	       btfss status,z
; 697: Goto sample_in4
	GOTO L0041
; 698: 
; 699: 
; 700: s003: 
L0039:
; 701: ASM:        movff porta,postinc0
	       movff porta,postinc0
; 702: ii = 2
	MOVLW 0x02
	MOVWF 0x02A
; 703: s003b: 
L0040:
; 704: ASM:        nop
	       nop
; 705: ASM:        nop
	       nop
; 706: ASM:        nop
	       nop
; 707: ASM:        decfsz ii,f
	       decfsz ii,f
; 708: Goto s003b
	GOTO L0040
; 709: ASM:        decfsz i,f
	       decfsz i,f
; 710: Goto s003
	GOTO L0039
; 711: ASM:        decfsz max,f
	       decfsz max,f
; 712: Goto s003
	GOTO L0039
; 713: 
; 714: Return
	RETURN
; 715: 
; 716: 
; 717: sample_in4: 
L0041:
; 718: st = phase_d - 3
	MOVLW 0x03
	SUBWF 0x02D,W
	MOVWF 0x01C
; 719:  '50, 100, 200, 500uSec, 1m, 2m, 5mSec
; 720: st1 = LookUp(2, 4, 9, 23, 48, 96, 237), st
	MOVF 0x01C,W
	SUBLW 0x06
	BTFSS STATUS,C
	BRA L0183
	RCALL L0184
	MOVWF 0x01D
	BRA L0183
L0184:
	MOVLW 0x0D
	MOVWF PCLATH
	MOVLW 0x00
	MOVWF PCLATU
	RLNCF 0x01C,W
	ADDWF PCL,F
	RETLW 0x02
	RETLW 0x04
	RETLW 0x09
	RETLW 0x17
	RETLW 0x30
	RETLW 0x60
	RETLW 0xED
L0183:
; 721: 
; 722: s004: 
L0042:
; 723: ASM:        movff porta,postinc0
	       movff porta,postinc0
; 724: ASM:        movff st1,us_register 'wacht aantal us
	       movff st1,us_register
; 725: w_loop_us: 
L0043:
; 726: ii = 2
	MOVLW 0x02
	MOVWF 0x02A
; 727: s004b: 
L0044:
; 728: ASM:        nop
	       nop
; 729: ASM:        nop
	       nop
; 730: ASM:        nop
	       nop
; 731: ASM:        nop
	       nop
; 732: ASM:        nop
	       nop
; 733: ASM:        decfsz ii,f
	       decfsz ii,f
; 734: Goto s004b
	GOTO L0044
; 735: ASM:        decfsz us_register,f
	       decfsz us_register,f
; 736: Goto w_loop_us
	GOTO L0043
; 737: ASM:        decfsz i,f
	       decfsz i,f
; 738: Goto s004
	GOTO L0042
; 739: ASM:        decfsz max,f
	       decfsz max,f
; 740: Goto s004
	GOTO L0042
; 741: 
; 742: Return
	RETURN
; 743: 
; 744: loadparameters: 
L0045:
; 745: Read 01, phase_d
	MOVLW 0x01
	MOVWF EEADR
	BCF EECON1,EEPGD
	BCF EECON1,CFGS
	BSF EECON1,RD
	NOP
	MOVF EEDATA,W
	MOVWF 0x02D
; 746: Read 02, phase_tk
	MOVLW 0x02
	MOVWF EEADR
	BCF EECON1,EEPGD
	BCF EECON1,CFGS
	BSF EECON1,RD
	NOP
	MOVF EEDATA,W
	MOVWF 0x02E
; 747: Read 03, phase_tpn
	MOVLW 0x03
	MOVWF EEADR
	BCF EECON1,EEPGD
	BCF EECON1,CFGS
	BSF EECON1,RD
	NOP
	MOVF EEDATA,W
	MOVWF 0x02F
; 748: Return
	RETURN
; 749: 
; 750: char_u: 
L0046:
; 751: ASM:        MOVLW 0XF8
	       MOVLW 0XF8
; 752: ASM:        call gl01
	       call gl01
; 753: ASM:        MOVLW 0X40
	       MOVLW 0X40
; 754: ASM:        CALL GL01
	       CALL GL01
; 755: ASM:        MOVLW 0X80
	       MOVLW 0X80
; 756: ASM:        CALL GL01
	       CALL GL01
; 757: ASM:        MOVLW 0X80
	       MOVLW 0X80
; 758: ASM:        CALL GL01
	       CALL GL01
; 759: ASM:        MOVLW 0X78
	       MOVLW 0X78
; 760: ASM:        CALL GL01
	       CALL GL01
; 761: ASM:        GOTO GW99
	       GOTO GW99
; 762: Return
	RETURN
; 763: 
; 764: welcome: 
L0047:
; 765: GLcdclear
	MOVLW 0x00
	CALL GL10
; 766: GLcdposition 0, 16
	MOVLW 0x00
	MOVWF R3L
	MOVLW 0x10
	MOVWF R3H
	CALL GL30
; 767: GLcdwrite "Logic An"
	MOVLW 0x4C
	CALL GW00
	MOVLW 0x6F
	CALL GW00
	MOVLW 0x67
	CALL GW00
	MOVLW 0x69
	CALL GW00
	MOVLW 0x63
	CALL GW00
	MOVLW 0x20
	CALL GW00
	MOVLW 0x41
	CALL GW00
	MOVLW 0x6E
	CALL GW00
; 768: GLcdposition 8, 0
	MOVLW 0x08
	MOVWF R3L
	MOVLW 0x00
	MOVWF R3H
	CALL GL30
; 769: GLcdwrite "alyser"
	MOVLW 0x61
	CALL GW00
	MOVLW 0x6C
	CALL GW00
	MOVLW 0x79
	CALL GW00
	MOVLW 0x73
	CALL GW00
	MOVLW 0x65
	CALL GW00
	MOVLW 0x72
	CALL GW00
; 770: GLcdposition 1, 23
	MOVLW 0x01
	MOVWF R3L
	MOVLW 0x17
	MOVWF R3H
	CALL GL30
; 771: GLcdwrite "Version"
	MOVLW 0x56
	CALL GW00
	MOVLW 0x65
	CALL GW00
	MOVLW 0x72
	CALL GW00
	MOVLW 0x73
	CALL GW00
	MOVLW 0x69
	CALL GW00
	MOVLW 0x6F
	CALL GW00
	MOVLW 0x6E
	CALL GW00
; 772: GLcdposition 9, 7
	MOVLW 0x09
	MOVWF R3L
	MOVLW 0x07
	MOVWF R3H
	CALL GL30
; 773: GLcdwrite "2.02"
	MOVLW 0x32
	CALL GW00
	MOVLW 0x2E
	CALL GW00
	MOVLW 0x30
	CALL GW00
	MOVLW 0x32
	CALL GW00
; 774: GLcdposition 2, 17
	MOVLW 0x02
	MOVWF R3L
	MOVLW 0x11
	MOVWF R3H
	CALL GL30
; 775: GLcdwrite "Copyrigh"
	MOVLW 0x43
	CALL GW00
	MOVLW 0x6F
	CALL GW00
	MOVLW 0x70
	CALL GW00
	MOVLW 0x79
	CALL GW00
	MOVLW 0x72
	CALL GW00
	MOVLW 0x69
	CALL GW00
	MOVLW 0x67
	CALL GW00
	MOVLW 0x68
	CALL GW00
; 776: GLcdposition 10, 1
	MOVLW 0x0A
	MOVWF R3L
	MOVLW 0x01
	MOVWF R3H
	CALL GL30
; 777: GLcdwrite "t 2006"
	MOVLW 0x74
	CALL GW00
	MOVLW 0x20
	CALL GW00
	MOVLW 0x32
	CALL GW00
	MOVLW 0x30
	CALL GW00
	MOVLW 0x30
	CALL GW00
	MOVLW 0x36
	CALL GW00
; 778: GLcdposition 3, 23
	MOVLW 0x03
	MOVWF R3L
	MOVLW 0x17
	MOVWF R3H
	CALL GL30
; 779: GLcdwrite "Segment"
	MOVLW 0x53
	CALL GW00
	MOVLW 0x65
	CALL GW00
	MOVLW 0x67
	CALL GW00
	MOVLW 0x6D
	CALL GW00
	MOVLW 0x65
	CALL GW00
	MOVLW 0x6E
	CALL GW00
	MOVLW 0x74
	CALL GW00
; 780: GLcdposition 11, 7
	MOVLW 0x0B
	MOVWF R3L
	MOVLW 0x07
	MOVWF R3H
	CALL GL30
; 781: GLcdwrite "b.v."
	MOVLW 0x62
	CALL GW00
	MOVLW 0x2E
	CALL GW00
	MOVLW 0x76
	CALL GW00
	MOVLW 0x2E
	CALL GW00
; 782: WaitMs 1750
	MOVLW 0xD6
	MOVWF R0L
	MOVLW 0x06
	MOVWF R0H
	CALL W001
; 783: Return
	RETURN
; 784: 
; 785: On High Interrupt 'interrupt routine
L0049:
; 786: 
; 787: If PIR1.TMR1IF = 1 Then
	BTFSS 0xF9E,0
	GOTO L0185
; 788: PIR1.TMR1IF = 0
	BCF 0xF9E,0
; 789: ASM:        decfsz tmr1_teller,F
	       decfsz tmr1_teller,F
; 790: ASM:        retfie fast
	       retfie fast
; 791: PIE1.TMR1IE = 0
	BCF 0xF9D,0
; 792: Gosub sample_in1
	CALL L0034
; 793: beginw = 0
	CLRF 0x022
	CLRF 0x023
; 794: INTCON.RBIE = 0 'reset RB port change interrupt bit
	BCF 0xFF2,3
; 795: Gosub draws 'wat op het scherm moet komen
	CALL L0017
; 796: INTCON.RBIE = 1 'set RB port change interrupt bit
	BSF 0xFF2,3
; 797: max = 1
	MOVLW 0x01
	MOVWF 0x021
; 798: ASM:        lfsr fsr0,sample
	       lfsr fsr0,sample
; 799: TMR1H = 0
	CLRF 0xFCF
; 800: tmr1_teller = 15 + phase_d
	MOVLW 0x0F
	ADDWF 0x02D,W
	MOVWF 0x034
; 801: PIR1.TMR1IF = 0
	BCF 0xF9E,0
; 802: PIE1.TMR1IE = 1
	BSF 0xF9D,0
; 803: Endif
L0185:	MOVLB 0x00
; 804: 
; 805: If INTCON.RBIF = 1 Then
	BTFSS 0xFF2,0
	GOTO L0186
; 806: Gosub getkey
	CALL L0015
; 807: If prog = 0 Then Gosub select1 Else Gosub select2
	BTFSC 0x014,0
	GOTO L0187
	CALL L0008
	GOTO L0188
L0187:	MOVLB 0x00
	CALL L0009
L0188:	MOVLB 0x00
; 808: flag1 = 1
	BSF 0x014,1
; 809: INTCON.RBIF = 0
	BCF 0xFF2,0
; 810: Endif
L0186:	MOVLB 0x00
; 811: 
; 812: If INTCON.TMR0IF = 1 Then
	BTFSS 0xFF2,2
	GOTO L0189
; 813: INTCON.TMR0IF = 0
	BCF 0xFF2,2
; 814: lt = lt + 1
	MOVF 0x02C,W
	ADDLW 0x01
	MOVWF 0x02C
; 815: If lt > 75 Then
	MOVF 0x02C,W
	SUBLW 0x4B
	BTFSC STATUS,C
	GOTO L0190
; 816: glcd_light = 0
	BCF 0xF82,2
; 817: T0CON.TMR0ON = 0
	BCF 0xFD5,7
; 818: Endif
L0190:	MOVLB 0x00
; 819: Endif
L0189:	MOVLB 0x00
; 820: Resume
	RETURN
; End of program
L0191:	BRA L0191
; Division Routine
D001:	MOVLW 0x10
	MOVWF R3L
	CLRF R2H
	CLRF R2L
D002:	RLCF R0H,W
	RLCF R2L,F
	RLCF R2H,F
	MOVF R1L,W
	SUBWF R2L,F
	MOVF R1H,W
	BTFSS STATUS,C
	INCFSZ R1H,W
	SUBWF R2H,F
	BTFSC STATUS,C
	BRA D003
	MOVF R1L,W
	ADDWF R2L,F
	MOVF R1H,W
	BTFSC STATUS,C
	INCFSZ R1H,W
	ADDWF R2H,F
	BCF STATUS,C
D003:	RLCF R0L,F
	RLCF R0H,F
	DECFSZ R3L,F
	BRA D002
	MOVF R0L,W
	RETURN
; Comparison Routine
C001:	MOVWF R1L
	MOVLW 0x05
	BRA C007
C002:	MOVWF R1L
	MOVLW 0x02
	BRA C007
C003:	MOVWF R1L
	MOVLW 0x06
	BRA C007
C004:	MOVWF R1L
	MOVLW 0x03
	BRA C007
C005:	MOVWF R1L
	MOVLW 0x04
	BRA C007
C006:	MOVWF R1L
	MOVLW 0x01
	BRA C007
C007:	MOVWF R4L
	MOVF R1H,W
	SUBWF R0H,W
	BTFSS STATUS,Z
	BRA C008
	MOVF R1L,W
	SUBWF R0L,W
C008:	MOVLW 0x04
	BTFSC STATUS,C
	MOVLW 0x01
	BTFSC STATUS,Z
	MOVLW 0x02
	ANDWF R4L,W
	BTFSS STATUS,Z
	MOVLW 0xFF
	RETURN
; Waitms Routine
W001:	MOVF R0L,F
	BTFSC STATUS,Z
	BRA W002
	RCALL W003
	DECF R0L,F
	NOP
	NOP
	NOP
	NOP
	NOP
	BRA W001
W002:	MOVF R0H,F
	BTFSC STATUS,Z
	RETURN
	RCALL W003
	DECF R0H,F
	DECF R0L,F
	BRA W001
W003:	MOVLW 0x0C
	MOVWF R2H
W004:	DECFSZ R2H,F
	BRA W004
	NOP
	NOP
	MOVLW 0xC6
	MOVWF R1L
W005:	DECFSZ R1L,F
	BRA W006
	RCALL W007
	RCALL W007
	NOP
	NOP
	RETURN
W006:	RCALL W007
	BRA W005
W007:	MOVLW 0x0D
	MOVWF R2L
W008:	DECFSZ R2L,F
	BRA W008
	NOP
	RETURN
; Waitus Routine - Byte Argument
X001:	MOVLW 0x01
	SUBWF R4L,F
	BTFSS STATUS,C
	RETURN
	BRA X002
X002:	MOVLW 0x01
	SUBWF R4L,F
	NOP
	NOP
	NOP
	NOP
	BTFSS STATUS,C
	RETURN
	BRA X002
; Waitus Routine - Word Argument
Y001:	MOVLW 0x02
	SUBWF R4L,F
	CLRF WREG
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF R4H,F
	BTFSS STATUS,C
	RETURN
	BRA Y002
Y002:	MOVLW 0x01
	SUBWF R4L,F
	CLRF WREG
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF R4H,F
	BTFSS STATUS,C
	RETURN
	BRA Y002
; Adcin Routine
A001:	RLCF R0L,F
	RLCF R0L,F
	MOVLW 0x80
	ANDWF ADCON2,F
	MOVLW 0x3C
	ANDWF R0L,W
	IORLW 0x01
	MOVWF ADCON0
	MOVLW 0x03
	IORWF ADCON2,F
	MOVLW 0x14
	MOVWF R4L
	CALL X001
	BSF ADCON0,GO
A002:	BTFSC ADCON0,GO
	BRA A002
	BCF PIR1,ADIF
	BCF ADCON0,ADON
	RETURN
; GLcdout Routine
GL01:	BSF 0xF82,0
	BCF 0xF82,1
	MOVWF 0xF83
	BSF 0xF84,0
	CALL GLX0
	BCF 0xF84,0
	CALL GLX3
	RETURN
; GLcdcmdout Routine
GL02:	BCF 0xF82,0
	BCF 0xF82,1
	MOVWF 0xF83
	BSF 0xF84,0
	CALL GLX0
	BCF 0xF84,0
	CALL GLX3
	RETURN
; GLcdclear Routine
GL10:	MOVWF R2H
	BSF 0xF84,1
	BSF 0xF84,2
	MOVLW 0x08
	MOVWF R3L
GL11:	DECF R3L,W
	ADDLW 0xB8
	CALL GL02
	MOVLW 0x40
	CALL GL02
	MOVLW 0x40
	MOVWF R3H
GL12:	MOVF R2H,W
	CALL GL01
	DECFSZ R3H,F
	BRA GL12
	DECFSZ R3L,F
	BRA GL11
	MOVLW 0xC0
	CALL GL02
	BCF 0xF84,1
	BCF 0xF84,2
	RETURN
; GLcdpset Routine
GL20:	BCF 0xF84,1
	BCF 0xF84,2
	BTFSC R3L,6
	BSF 0xF84,2
	BTFSS R3L,6
	BSF 0xF84,1
	BSF R3L,6
	MOVF R3H,W
	ANDLW 0x38
	MOVWF R2H
	RRCF R2H,F
	RRCF R2H,F
	RRCF R2H,W
	IORLW 0xB8
	MOVWF R2H
	CALL GL02
	MOVLW 0x07
	ANDWF R3H,F
	INCF R3H,F
	BCF STATUS,C
	MOVLW 0x01
	MOVWF R2L
GL21:	RLCF R2L,F
	DECFSZ R3H,F
	BRA GL21
	RRCF R2L,F
	MOVF R3L,W
	CALL GL02
	CALL GL03
	IORWF R2L,W
	MOVWF R3H
	MOVF R3L,W
	CALL GL02
	MOVF R3H,W
	CALL GL01
	BCF 0xF84,1
	BCF 0xF84,2
	RETURN
; GLcdin Routine
GL03:	BSF 0xF82,0
	BSF 0xF82,1
	RCALL GLX1
	BSF 0xF84,0
	RCALL GLX0
	BCF 0xF84,0
	RCALL GLX3
	BSF 0xF82,0
	BSF 0xF82,1
	RCALL GLX1
	BSF 0xF84,0
	RCALL GLX0
	MOVF 0xF83,W
	BCF 0xF84,0
	RCALL GLX2
	RETURN
GLX0:	MOVLW 0x06
	movwf R0L
GLX0_1:	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	decfsz R0L, F
	goto GLX0_1
	RETURN
GLX1:	MOVLW 0xFF
	MOVWF 0xF95
	RETURN
GLX2:	CLRF 0xF95
	RETURN
GLX3:	BCF 0xF82,0
	BSF 0xF82,1
	RCALL GLX1
	BSF 0xF84,0
	RCALL GLX0
	MOVF 0xF83,W
	BCF 0xF84,0
	RCALL GLX2
	MOVWF R4H
	BTFSC R4H,7
	BRA GLX3
	RETURN
; GLcdposition Routine
GL30:	BCF 0xF84,1
	BCF 0xF84,2
	BTFSC R3L,3
	BSF 0xF84,2
	BTFSS R3L,3
	BSF 0xF84,1
	MOVF R3L,W
	IORLW 0xB8
	CALL GL02
	BSF R3H,6
	MOVF R3H,W
	CALL GL02
	RETURN
; GLcdwrite Routine
GW00:	MOVWF R4L
GW01:	MOVLW 0x41
	CPFSEQ R4L
	BRA GW02
	MOVLW 0xFC
	CALL GL01
	MOVLW 0x22
	CALL GL01
	MOVLW 0x22
	CALL GL01
	MOVLW 0x22
	CALL GL01
	MOVLW 0xFC
	CALL GL01
	GOTO GW99
GW02:	MOVLW 0x43
	CPFSEQ R4L
	BRA GW03
	MOVLW 0x7C
	CALL GL01
	MOVLW 0x82
	CALL GL01
	MOVLW 0x82
	CALL GL01
	MOVLW 0x82
	CALL GL01
	MOVLW 0x44
	CALL GL01
	GOTO GW99
GW03:	MOVLW 0x44
	CPFSEQ R4L
	BRA GW04
	MOVLW 0xFE
	CALL GL01
	MOVLW 0x82
	CALL GL01
	MOVLW 0x82
	CALL GL01
	MOVLW 0x44
	CALL GL01
	MOVLW 0x38
	CALL GL01
	GOTO GW99
GW04:	MOVLW 0x49
	CPFSEQ R4L
	BRA GW05
	MOVLW 0x00
	CALL GL01
	MOVLW 0x82
	CALL GL01
	MOVLW 0xFE
	CALL GL01
	MOVLW 0x82
	CALL GL01
	MOVLW 0x00
	CALL GL01
	GOTO GW99
GW05:	MOVLW 0x4C
	CPFSEQ R4L
	BRA GW06
	MOVLW 0xFE
	CALL GL01
	MOVLW 0x80
	CALL GL01
	MOVLW 0x80
	CALL GL01
	MOVLW 0x80
	CALL GL01
	MOVLW 0x80
	CALL GL01
	GOTO GW99
GW06:	MOVLW 0x52
	CPFSEQ R4L
	BRA GW07
	MOVLW 0xFE
	CALL GL01
	MOVLW 0x12
	CALL GL01
	MOVLW 0x32
	CALL GL01
	MOVLW 0x52
	CALL GL01
	MOVLW 0x8C
	CALL GL01
	GOTO GW99
GW07:	MOVLW 0x53
	CPFSEQ R4L
	BRA GW08
	MOVLW 0x8C
	CALL GL01
	MOVLW 0x92
	CALL GL01
	MOVLW 0x92
	CALL GL01
	MOVLW 0x92
	CALL GL01
	MOVLW 0x62
	CALL GL01
	GOTO GW99
GW08:	MOVLW 0x56
	CPFSEQ R4L
	BRA GW09
	MOVLW 0x3E
	CALL GL01
	MOVLW 0x40
	CALL GL01
	MOVLW 0x80
	CALL GL01
	MOVLW 0x40
	CALL GL01
	MOVLW 0x3E
	CALL GL01
	GOTO GW99
GW09:	MOVLW 0x61
	CPFSEQ R4L
	BRA GW0A
	MOVLW 0x40
	CALL GL01
	MOVLW 0xA8
	CALL GL01
	MOVLW 0xA8
	CALL GL01
	MOVLW 0xA8
	CALL GL01
	MOVLW 0xF0
	CALL GL01
	GOTO GW99
GW0A:	MOVLW 0x62
	CPFSEQ R4L
	BRA GW0B
	MOVLW 0xFE
	CALL GL01
	MOVLW 0x90
	CALL GL01
	MOVLW 0x88
	CALL GL01
	MOVLW 0x88
	CALL GL01
	MOVLW 0x70
	CALL GL01
	GOTO GW99
GW0B:	MOVLW 0x63
	CPFSEQ R4L
	BRA GW0C
	MOVLW 0x70
	CALL GL01
	MOVLW 0x88
	CALL GL01
	MOVLW 0x88
	CALL GL01
	MOVLW 0x88
	CALL GL01
	MOVLW 0x40
	CALL GL01
	GOTO GW99
GW0C:	MOVLW 0x65
	CPFSEQ R4L
	BRA GW0D
	MOVLW 0x70
	CALL GL01
	MOVLW 0xA8
	CALL GL01
	MOVLW 0xA8
	CALL GL01
	MOVLW 0xA8
	CALL GL01
	MOVLW 0x30
	CALL GL01
	GOTO GW99
GW0D:	MOVLW 0x67
	CPFSEQ R4L
	BRA GW0E
	MOVLW 0x18
	CALL GL01
	MOVLW 0xA4
	CALL GL01
	MOVLW 0xA4
	CALL GL01
	MOVLW 0xA4
	CALL GL01
	MOVLW 0x7C
	CALL GL01
	GOTO GW99
GW0E:	MOVLW 0x68
	CPFSEQ R4L
	BRA GW0F
	MOVLW 0xFE
	CALL GL01
	MOVLW 0x10
	CALL GL01
	MOVLW 0x08
	CALL GL01
	MOVLW 0x08
	CALL GL01
	MOVLW 0xF0
	CALL GL01
	GOTO GW99
GW0F:	MOVLW 0x69
	CPFSEQ R4L
	BRA GW10
	MOVLW 0x00
	CALL GL01
	MOVLW 0x88
	CALL GL01
	MOVLW 0xFA
	CALL GL01
	MOVLW 0x80
	CALL GL01
	MOVLW 0x00
	CALL GL01
	GOTO GW99
GW10:	MOVLW 0x6C
	CPFSEQ R4L
	BRA GW11
	MOVLW 0x00
	CALL GL01
	MOVLW 0x82
	CALL GL01
	MOVLW 0xFE
	CALL GL01
	MOVLW 0x80
	CALL GL01
	MOVLW 0x00
	CALL GL01
	GOTO GW99
GW11:	MOVLW 0x6D
	CPFSEQ R4L
	BRA GW12
	MOVLW 0xF8
	CALL GL01
	MOVLW 0x08
	CALL GL01
	MOVLW 0x30
	CALL GL01
	MOVLW 0x08
	CALL GL01
	MOVLW 0xF0
	CALL GL01
	GOTO GW99
GW12:	MOVLW 0x6E
	CPFSEQ R4L
	BRA GW13
	MOVLW 0xF8
	CALL GL01
	MOVLW 0x10
	CALL GL01
	MOVLW 0x08
	CALL GL01
	MOVLW 0x08
	CALL GL01
	MOVLW 0xF0
	CALL GL01
	GOTO GW99
GW13:	MOVLW 0x6F
	CPFSEQ R4L
	BRA GW14
	MOVLW 0x70
	CALL GL01
	MOVLW 0x88
	CALL GL01
	MOVLW 0x88
	CALL GL01
	MOVLW 0x88
	CALL GL01
	MOVLW 0x70
	CALL GL01
	GOTO GW99
GW14:	MOVLW 0x70
	CPFSEQ R4L
	BRA GW15
	MOVLW 0xF8
	CALL GL01
	MOVLW 0x28
	CALL GL01
	MOVLW 0x28
	CALL GL01
	MOVLW 0x28
	CALL GL01
	MOVLW 0x10
	CALL GL01
	GOTO GW99
GW15:	MOVLW 0x72
	CPFSEQ R4L
	BRA GW16
	MOVLW 0xF8
	CALL GL01
	MOVLW 0x10
	CALL GL01
	MOVLW 0x08
	CALL GL01
	MOVLW 0x08
	CALL GL01
	MOVLW 0x10
	CALL GL01
	GOTO GW99
GW16:	MOVLW 0x73
	CPFSEQ R4L
	BRA GW17
	MOVLW 0x90
	CALL GL01
	MOVLW 0xA8
	CALL GL01
	MOVLW 0xA8
	CALL GL01
	MOVLW 0xA8
	CALL GL01
	MOVLW 0x40
	CALL GL01
	GOTO GW99
GW17:	MOVLW 0x74
	CPFSEQ R4L
	BRA GW18
	MOVLW 0x08
	CALL GL01
	MOVLW 0x7E
	CALL GL01
	MOVLW 0x88
	CALL GL01
	MOVLW 0x80
	CALL GL01
	MOVLW 0x40
	CALL GL01
	GOTO GW99
GW18:	MOVLW 0x76
	CPFSEQ R4L
	BRA GW19
	MOVLW 0x38
	CALL GL01
	MOVLW 0x40
	CALL GL01
	MOVLW 0x80
	CALL GL01
	MOVLW 0x40
	CALL GL01
	MOVLW 0x38
	CALL GL01
	GOTO GW99
GW19:	MOVLW 0x79
	CPFSEQ R4L
	BRA GW1A
	MOVLW 0x18
	CALL GL01
	MOVLW 0xA0
	CALL GL01
	MOVLW 0xA0
	CALL GL01
	MOVLW 0xA0
	CALL GL01
	MOVLW 0x78
	CALL GL01
	GOTO GW99
GW1A:	MOVLW 0x31
	CPFSEQ R4L
	BRA GW1B
	MOVLW 0x00
	CALL GL01
	MOVLW 0x84
	CALL GL01
	MOVLW 0xFE
	CALL GL01
	MOVLW 0x80
	CALL GL01
	MOVLW 0x00
	CALL GL01
	GOTO GW99
GW1B:	MOVLW 0x32
	CPFSEQ R4L
	BRA GW1C
	MOVLW 0x84
	CALL GL01
	MOVLW 0xC2
	CALL GL01
	MOVLW 0xA2
	CALL GL01
	MOVLW 0x92
	CALL GL01
	MOVLW 0x8C
	CALL GL01
	GOTO GW99
GW1C:	MOVLW 0x33
	CPFSEQ R4L
	BRA GW1D
	MOVLW 0x42
	CALL GL01
	MOVLW 0x82
	CALL GL01
	MOVLW 0x8A
	CALL GL01
	MOVLW 0x96
	CALL GL01
	MOVLW 0x62
	CALL GL01
	GOTO GW99
GW1D:	MOVLW 0x34
	CPFSEQ R4L
	BRA GW1E
	MOVLW 0x30
	CALL GL01
	MOVLW 0x28
	CALL GL01
	MOVLW 0x24
	CALL GL01
	MOVLW 0xFE
	CALL GL01
	MOVLW 0x20
	CALL GL01
	GOTO GW99
GW1E:	MOVLW 0x35
	CPFSEQ R4L
	BRA GW1F
	MOVLW 0x4E
	CALL GL01
	MOVLW 0x8A
	CALL GL01
	MOVLW 0x8A
	CALL GL01
	MOVLW 0x8A
	CALL GL01
	MOVLW 0x72
	CALL GL01
	GOTO GW99
GW1F:	MOVLW 0x36
	CPFSEQ R4L
	BRA GW20
	MOVLW 0x78
	CALL GL01
	MOVLW 0x94
	CALL GL01
	MOVLW 0x92
	CALL GL01
	MOVLW 0x92
	CALL GL01
	MOVLW 0x60
	CALL GL01
	GOTO GW99
GW20:	MOVLW 0x37
	CPFSEQ R4L
	BRA GW21
	MOVLW 0x02
	CALL GL01
	MOVLW 0xE2
	CALL GL01
	MOVLW 0x12
	CALL GL01
	MOVLW 0x0A
	CALL GL01
	MOVLW 0x06
	CALL GL01
	GOTO GW99
GW21:	MOVLW 0x38
	CPFSEQ R4L
	BRA GW22
	MOVLW 0x6C
	CALL GL01
	MOVLW 0x92
	CALL GL01
	MOVLW 0x92
	CALL GL01
	MOVLW 0x92
	CALL GL01
	MOVLW 0x6C
	CALL GL01
	GOTO GW99
GW22:	MOVLW 0x39
	CPFSEQ R4L
	BRA GW23
	MOVLW 0x0C
	CALL GL01
	MOVLW 0x92
	CALL GL01
	MOVLW 0x92
	CALL GL01
	MOVLW 0x52
	CALL GL01
	MOVLW 0x3C
	CALL GL01
	GOTO GW99
GW23:	MOVLW 0x30
	CPFSEQ R4L
	BRA GW24
	MOVLW 0x7C
	CALL GL01
	MOVLW 0xA2
	CALL GL01
	MOVLW 0x92
	CALL GL01
	MOVLW 0x8A
	CALL GL01
	MOVLW 0x7C
	CALL GL01
	GOTO GW99
GW24:	MOVLW 0x2B
	CPFSEQ R4L
	BRA GW25
	MOVLW 0x10
	CALL GL01
	MOVLW 0x10
	CALL GL01
	MOVLW 0x7C
	CALL GL01
	MOVLW 0x10
	CALL GL01
	MOVLW 0x10
	CALL GL01
	GOTO GW99
GW25:	MOVLW 0x2D
	CPFSEQ R4L
	BRA GW26
	MOVLW 0x10
	CALL GL01
	MOVLW 0x10
	CALL GL01
	MOVLW 0x10
	CALL GL01
	MOVLW 0x10
	CALL GL01
	MOVLW 0x10
	CALL GL01
	GOTO GW99
GW26:	MOVLW 0x2E
	CPFSEQ R4L
	BRA GW27
	MOVLW 0x00
	CALL GL01
	MOVLW 0xC0
	CALL GL01
	MOVLW 0xC0
	CALL GL01
	MOVLW 0x00
	CALL GL01
	MOVLW 0x00
	CALL GL01
	GOTO GW99
GW27:	MOVLW 0x2F
	CPFSEQ R4L
	BRA GW28
	MOVLW 0x40
	CALL GL01
	MOVLW 0x20
	CALL GL01
	MOVLW 0x10
	CALL GL01
	MOVLW 0x08
	CALL GL01
	MOVLW 0x04
	CALL GL01
	GOTO GW99
GW28:	MOVLW 0x3C
	CPFSEQ R4L
	BRA GW29
	MOVLW 0x10
	CALL GL01
	MOVLW 0x28
	CALL GL01
	MOVLW 0x44
	CALL GL01
	MOVLW 0x82
	CALL GL01
	MOVLW 0x00
	CALL GL01
	GOTO GW99
GW29:	MOVLW 0x3E
	CPFSEQ R4L
	BRA GW2A
	MOVLW 0x00
	CALL GL01
	MOVLW 0x82
	CALL GL01
	MOVLW 0x44
	CALL GL01
	MOVLW 0x28
	CALL GL01
	MOVLW 0x10
	CALL GL01
	GOTO GW99
GW2A:	MOVLW 0x20
	CPFSEQ R4L
	BRA GW2B
	MOVLW 0x00
	CALL GL01
	MOVLW 0x00
	CALL GL01
	MOVLW 0x00
	CALL GL01
	MOVLW 0x00
	CALL GL01
	MOVLW 0x00
	CALL GL01
	GOTO GW99
GW2B:	NOP
GW99:	MOVLW 0x00
	CALL GL01
	RETURN
; GLcdpreset Routine
GL40:	BCF 0xF84,1
	BCF 0xF84,2
	BTFSC R3L,6
	BSF 0xF84,2
	BTFSS R3L,6
	BSF 0xF84,1
	BSF R3L,6
	MOVF R3H,W
	ANDLW 0x38
	MOVWF R2H
	RRCF R2H,F
	RRCF R2H,F
	RRCF R2H,W
	IORLW 0xB8
	MOVWF R2H
	CALL GL02
	MOVLW 0x07
	ANDWF R3H,F
	INCF R3H,F
	BCF STATUS,C
	MOVLW 0x01
	MOVWF R2L
GL41:	RLCF R2L,F
	DECFSZ R3H,F
	BRA GL41
	RRCF R2L,F
	COMF R2L,F
	MOVF R3L,W
	CALL GL02
	CALL GL03
	ANDWF R2L,W
	MOVWF R3H
	MOVF R3L,W
	CALL GL02
	MOVF R3H,W
	CALL GL01
	BCF 0xF84,1
	BCF 0xF84,2
	RETURN
; GLcdclean Routine
GL50:	MOVF R3L,W
	SUBWF R3H,W
	BTFSS STATUS,C
	BRA GL51
	MOVLW 0x00
	CALL GL01
	INCF R3L,F
	BRA GL50
GL51:	RETURN
; GLcdout Decimal Conversion Routine
GL61:	BSF R3H,7
	MOVLW 0x27
	MOVWF R1H
	MOVLW 0x10
	RCALL GL62
	MOVLW 0x03
	MOVWF R1H
	MOVLW 0xE8
	RCALL GL62
	CLRF R1H
	MOVLW 0x64
	RCALL GL62
	CLRF R1H
	MOVLW 0x0A
	RCALL GL62
	MOVF R2L,W
	BRA GL63
GL62:	MOVWF R1L
	MOVF R2H,W
	MOVWF R0H
	MOVF R2L,W
	MOVWF R0L
	CALL D001
	MOVF R0L,W
	BTFSS STATUS,Z
	BCF R3H,7
	BTFSC R3H,7
	RETURN
GL63:	ADDLW 0x30
	CALL GW00
	RETURN
; Configuration bytes settings
	ORG 0x300000
	DW 0x0600
	DW 0x000E
	DW 0x0000
	DW 0x0080
	DW 0xC00F
	DW 0xE00F
	DW 0x400F
; EEPROM data
	ORG 0xF00000
	DW 0x0000
	DW 0x0000
	DW 0x0001
; End of listing
	END
